<?php
$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);

function parse_day_to_year($vonis){
	$result = array();
	$month = (int)($vonis/30);
	$year = (int) ($month/12);
	$month = (int) ($month%12);
	$total = (int)($year*12*30+$month*30);
	$day = intval($vonis-$total);
	$result['year'] = $year;
	$result['month'] = $month;
	$result['day'] = $day;
	return $result;
}
function fetchStatusPutusanText($data,$idpihak){
	$status ='';
	foreach ($data->result() as $row) {
		if($row->ID==$idpihak){
			$satuan = $row->satuan;
			$infohukuman = '';
			if($satuan==1){
				$infohukuman = parse_day_to_year($row->durasiNominal);
				$year = '';$month = '';$day = '';
				if(!empty($infohukuman['year'])){
					$year = $infohukuman['year'].' Tahun ';
				}
				if(!empty($infohukuman['month'])){
					$month = $infohukuman['month'].' Bulan ';
				}
				if(!empty($infohukuman['day'])){
					$day = $infohukuman['day'].' Hari';
				}
				$infohukuman = '('.$year.$month.$day.')';
			}elseif($satuan==2){
				$infohukuman = 'Rp.'.number_format($row->durasiNominal,2,',','.');
			}
			$status .= $row->statusPutusan.' '.$infohukuman.'<br>';
		}
	}
	return $status;
}

function isPihakKeExist($pihakke,$data){
	foreach ($data->result() as $row) {
		if($row->pihakke==$pihakke){
			return TRUE;
		}
	}
	return FALSE;
}

$tanggal_putusan = '-';
$verstek = '-';
$sumber_hukum_put = '-';
$tanggal_minutasi = '-';
$catatan_putusan = '-';
$nilai_ganti_sengketa = 0;
$amar = '-';
$status_putusan_nama = '';

if($putusan !=''){
	if($putusan->num_rows>0){
		foreach ($putusan->result() as $row) {
			$tanggal_putusan = $this->tanggalhelper->convertDayDate($row->tglPutusan);
			$amar = $row->amar;
			$status_putusan_nama = $row->statusPutusan;
			$tanggal_minutasi = $this->tanggalhelper->convertDayDate($row->tglMinutasi);
			if($idalurperkara<100){
				$verstek = $row->isVerstek;
				$sumber_hukum_put = $row->sumberHukum;
			}
			$penetapan_hakim_pengawas =  $this->tanggalhelper->convertDayDate($row->tglPenetapanHakimPengawas);
			$nomor_penetapan_hakim_pengawas = $row->noPenetapanHakimPengawas;
			#$hakim_pengawas_nama = $row->hakim_pengawas_nama;
			#$kurator_nama = $row->kurator_nama;
			$nilai_ganti_sengketa = $row->nilaiGantiRugi;
			$tanggal_berita_putusan = $this->tanggalhelper->convertDayDate($row->tglMediaBerita);
			$tanggal_surat_kabar_putusan = $this->tanggalhelper->convertDayDate($row->tglSuratKabar);
			$nama_surat_kabar_putusan = $row->namaSuratKabar;
			$kirim_salinan_putusan_penyidik =  $this->tanggalhelper->convertDayDate($row->TglKirimSalinanPenyidik);
			$catatan_putusan = $row->keterangan;
		}
	}
}

?>
<div style="font-size:14px;">
	<table id='infoPerkara' style="font-size:14px;">
		<col width="15%">
		<col width="85%">
		<tbody>
			<tr>
				<td id="first-child">Tanggal Putusan</td>
				<td><?php echo (!empty($tanggal_putusan)? $tanggal_putusan:'');?></td>
			</tr>
			<?php if($idalurperkara<100){?>
			<tr>
				<td id="first-child">Putusan Verstek</td>
				<td><?php echo ($verstek=='Y')? 'Ya':'Tidak';?></td>
			</tr>
			<tr>
				<td id="first-child">Sumber Hukum</td>
				<td><?php echo (!empty($sumber_hukum_put)? $sumber_hukum_put:'');?></td>
			</tr>
			<?php } ?>
			<tr>
				<td id="first-child">Status Putusan</td>
				<td>
					<?php
					if($idalurperkara>100 AND $idalurperkara!=119){
						if($status_putusan!=''){
							if($status_putusan->num_rows>0){
					?>
					<div class="cssTable">
						<table id="tableinfo" style="margin:0px;padding:0px;">
							<col width="3%">
							<col width="37%">
							<col width="15%">
							<col width="45%">
							<tbody>
								<tr>
									<td>No</td>
									<td>Nama</td>
									<td>Tanggal Putusan</td>
									<td>Putusan</td>
								</tr>
							<?php
								$i=0;
								$repeat = True;
								$idss = 0;
								foreach ($status_putusan->result() as $rows) {
									if($idss!=$rows->ID){
										$repeat = False;
										$i++;
										$idss = $rows->ID;
									}else{
										$repeat = True;
									}
									if($repeat==False){
										echo "<tr>";
											$status_putusan_terdakwa = fetchStatusPutusanText($status_putusan,$rows->ID);
											echo "<td>".$i."</td>";
											echo "<td>".$rows->nama."</td>";
											echo "<td>".$this->tanggalhelper->convertDayDate($rows->tglPutusan)."</td>";
											echo "<td>".$status_putusan_terdakwa."</td>";
										echo "</tr>";
									}
									if(empty($idss)){
										$idss = $rows->ID;
									}
								}?>
							</tbody>
						</table>
					</div>
				<?php
						}
					}
				}else{
					echo $status_putusan_nama;
				}
				?>
				</td>
			</tr>
			<?php
			if($idalurperkara<100 AND $idalurperkara!=2){
			?>
				<tr>
					<td id="first-child">Nilai Ganti Kerugian (Rp.)</td>
					<td><?php echo (!empty($nilai_ganti_sengketa)? number_format($nilai_ganti_sengketa,0,",","."):'0');?></td>
				</tr>
			<?php
			}
			?>
			<tr>
				<td id="first-child">Amar Putusan</td>
				<td class='wrapword'><?php echo (!empty($amar)? $amar:'');?></td>
			</tr>
			<?php
			if($idalurperkara==3){
			?>
				<tr>
					<td id="first-child">Tanggal Penetapan Hakim Pengawas</td>
					<td style="padding:0px;padding-left:5px;"><?php echo (!empty($penetapan_hakim_pengawas)? $penetapan_hakim_pengawas:'');?></td>
				</tr>
				<tr>
					<td id="first-child">Nomor Penetapan Hakim Pengawas</td>
					<td style="padding:0px;padding-left:5px;"><?php echo (!empty($nomor_penetapan_hakim_pengawas)? $nomor_penetapan_hakim_pengawas:'');?></td>
				</tr>
				<tr>
					<td id="first-child">Hakim Pengawas</td>
					<td style="padding:0px;padding-left:5px;"><?php echo (!empty($hakim_pengawas_nama)? $hakim_pengawas_nama:'');?></td>
				</tr>
				<tr>
					<td id="first-child">Kurator</td>
					<td style="padding:0px;padding-left:5px;"><?php echo (!empty($kurator_nama)? $kurator_nama:'');?></td>
				</tr>
				<tr>
					<td id="first-child">Tanggal pengumuman dalam Berita Negara RI</td>
					<td style="padding:0px;padding-left:5px;"><?php echo (!empty($tanggal_berita_putusan)? $tanggal_berita_putusan:'');?></td>
				</tr>
				<tr>
					<td id="first-child">Tanggal dimuat dalam Surat Kabar</td>
					<td style="padding:0px;padding-left:5px;"><?php echo (!empty($tanggal_surat_kabar_putusan)? $tanggal_surat_kabar_putusan:'');?></td>
				</tr>
				<tr>
					<td id="first-child">Nama Surat Kabar</td>
					<td style="padding:0px;padding-left:5px;"><?php echo (!empty($nama_surat_kabar_putusan)? $nama_surat_kabar_putusan:'');?></td>
				</tr>
			<?php
				}
			?>			
			<tr>
				<td id="first-child" style="vertical-align:top;">Pemberitahuan Putusan (Jika Pihak Tidak Hadir Saat Pembacaan Putusan)</td>
					<td>
					<?php
						if($data_pemberitahuan!=''){
							if($data_pemberitahuan->num_rows>0){?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan Putusan</td>
										</tr>
									<?php
										$i=1;
										foreach ($data_pemberitahuan->result() as $row) {
											if($row->pihakke==1){
												echo '<tr>';
													echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,1).' '.$row->urutan.'</td>';
													echo '<td>'.$row->nama.'</td>';
													$tgl = (!empty($row->tglPemberitahuan))? $this->tanggalhelper->convertDayDate($row->tglPemberitahuan):'';
													echo '<td>'.$tgl.'</td>';
												echo '</tr>';
											}
											
										}?>
									</tbody>
								</table>
							</div>
							<?php
							}
						}
							?>	
						<br>
						<?php
						if($data_pemberitahuan!=''){
							if($data_pemberitahuan->num_rows>0 AND isPihakKeExist(2,$data_pemberitahuan)){?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan Putusan</td>
										</tr>
									<?php
										$i=1;
										foreach ($data_pemberitahuan->result() as $row) {
											if($row->pihakke==2){
												echo '<tr>';
													echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,2).' '.$row->urutan.'</td>';
													echo '<td>'.$row->nama.'</td>';
													$tgl = (!empty($row->tglPemberitahuan))? $this->tanggalhelper->convertDayDate($row->tglPemberitahuan):'';
													echo '<td>'.$tgl.'</td>';
												echo '</tr>';
											}
										}?>
										</tbody>
									</table>
								</div>
							<?php
								}
							}
							?>
							<br>
						<?php
						if($data_pemberitahuan!=''){
							if($data_pemberitahuan->num_rows>0 AND isPihakKeExist(3,$data_pemberitahuan)){?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan Putusan</td>
										</tr>
									<?php
										$i=1;
										foreach ($data_pemberitahuan->result() as $row) {
											if($row->pihakke==3){
												echo '<tr>';
													echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,3).' '.$row->urutan.'</td>';
													echo '<td>'.$row->nama.'</td>';
													$tgl = (!empty($row->tglPemberitahuan))? $this->tanggalhelper->convertDayDate($row->tglPemberitahuan):'';
													echo '<td>'.$tgl.'</td>';
												echo '</tr>';
											}
										}?>
										</tbody>
									</table>
								</div>
							<?php
								}
							}
							?>
								<br>
						<?php
						if($data_pemberitahuan!=''){
							if($data_pemberitahuan->num_rows>0 AND isPihakKeExist(4,$data_pemberitahuan)){?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan Putusan</td>
										</tr>
									<?php
										$i=1;
										foreach ($data_pemberitahuan->result() as $row) {
											if($row->pihakke==4){
												echo '<tr>';
													echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,4).' '.$row->urutan.'</td>';
													echo '<td>'.$row->nama.'</td>';
													$tgl = (!empty($row->tglPemberitahuan))? $this->tanggalhelper->convertDayDate($row->tglPemberitahuan):'';
													echo '<td>'.$tgl.'</td>';
												echo '</tr>';
											}
										}?>
										</tbody>
									</table>
								</div>
							<?php
								}
							}
							?>
				</td>
			</tr>
			<?php
			
			if($idalurperkara>100 AND $idalurperkara!=119){
			?>
			<tr>
				<td id="first-child" style="vertical-align:top;">Menerima Putusan</td>
				<td>
					<?php
						if($data_pemberitahuan!=''){
							if($data_pemberitahuan->num_rows>0){?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan Putusan</td>
										</tr>
									<?php
										$i=1;
										foreach ($data_pemberitahuan->result() as $row) {
											if($row->pihakke==1){
												echo '<tr>';
													echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,1).' '.$row->urutan.'</td>';
													echo '<td>'.$row->nama.'</td>';
													$tgl = (!empty($row->tglMenerimaPutusan))? $this->tanggalhelper->convertDayDate($row->tglMenerimaPutusan):'';
													echo '<td>'.$tgl.'</td>';
												echo '</tr>';
											}
											
										}?>
									</tbody>
								</table>
							</div>
							<?php
							}
						}
							?>	
						<br>
						<?php
						if($data_pemberitahuan!=''){
							if($data_pemberitahuan->num_rows>0 AND isPihakKeExist(2,$data_pemberitahuan)){?>
								<div class="cssTable">
									<table id="tableinfo" style="margin:0px;padding:0px;">
										<col width="20%">
										<col width="55%">
										<col width="25%">
										<tbody>
											<tr>
												<td>Status</td>
												<td>Nama</td>
												<td>Tanggal Pemberitahuan Putusan</td>
											</tr>
										<?php
											$i=1;
											foreach ($data_pemberitahuan->result() as $row) {
												if($row->pihakke==2){
													echo '<tr>';
														echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,2).' '.$row->urutan.'</td>';
														echo '<td>'.$row->nama.'</td>';
														$tgl = (!empty($row->tglMenerimaPutusan))? $this->tanggalhelper->convertDayDate($row->tglMenerimaPutusan):'';
														echo '<td>'.$tgl.'</td>';
													echo '</tr>';
												}
											}?>
										</tbody>
									</table>
								</div>
							<?php
							}
						}
						if($idalurperkara==120 OR $idalurperkara==121){
							
						}
						?>
				</td>
			</tr>
			<tr>
			<td id="first-child" style="vertical-align:top;">Kirim Salinan Putusan</td>
				<td>
					<?php
						if($data_pemberitahuan!=''){
							if($data_pemberitahuan->num_rows>0){?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan Putusan</td>
										</tr>
									<?php
										$i=1;
										foreach ($data_pemberitahuan->result() as $row) {
											if($row->pihakke==1){
												echo '<tr>';
													echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,1).' '.$row->urutan.'</td>';
													echo '<td>'.$row->nama.'</td>';
													$tgl = (!empty($row->tglKirimSalinan))? $this->tanggalhelper->convertDayDate($row->tglKirimSalinan):'';
													echo '<td>'.$tgl.'</td>';
												echo '</tr>';
											}
											
										}?>
									</tbody>
								</table>
							</div>
							<?php
							}
						}
							?>	
						<br>
						<?php
						if($data_pemberitahuan!=''){
							if($data_pemberitahuan->num_rows>0 AND isPihakKeExist(2,$data_pemberitahuan)){?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan Putusan</td>
										</tr>
									<?php
										$i=1;
										foreach ($data_pemberitahuan->result() as $row) {
											if($row->pihakke==2){
												echo '<tr>';
													echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,2).' '.$row->urutan.'</td>';
													echo '<td>'.$row->nama.'</td>';
													$tgl = (!empty($row->tglMenerimaPutusan))? $this->tanggalhelper->convertDayDate($row->tglMenerimaPutusan):'';
													echo '<td>'.$tgl.'</td>';
												echo '</tr>';
											}
										}?>
										</tbody>
									</table>
								</div>
							<?php
								}
							}
							?>
				</td>
		</tr>

		<tr>
			<td id="first-child" style="vertical-align:top;">Kirim Salinan Putusan Kepada Penyidik</td>
			<td style="padding:0px;padding-left:5px;"><?php echo (!empty($kirim_salinan_putusan_penyidik)? $kirim_salinan_putusan_penyidik:'');?></td>
		</tr>
		<?php
		}
		?>
		<tr>
			<td id="first-child">Tanggal Minutasi</td>
			<td style="padding:0px;padding-left:5px;"><?php echo (!empty($tanggal_minutasi)? $tanggal_minutasi:'');?></td>
		</tr>
		<tr>
			<td id="first-child">Keterangan</td>
			<td style="padding:0px;padding-left:5px;"><?php echo (!empty($catatan_putusan)? $catatan_putusan:'');?></td>
		</tr>
		</tbody>
	</table>
</div>
<script type="text/javascript">
closeLoading();
</script>
